<?php
include '../includes/db.php';
$message = '';
$stream = null;

// URL থেকে আইডি নিন
if (!isset($_GET['id']) && !isset($_POST['id'])) {
    header("Location: manage_streams.php");
    exit();
}
$id = isset($_POST['id']) ? intval($_POST['id']) : intval($_GET['id']);

// যদি ফর্ম সাবমিট করা হয়
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $title = $conn->real_escape_string($_POST['stream_title']);
    $stream_url = $conn->real_escape_string($_POST['stream_url']);
    $current_thumbnail = $_POST['current_thumbnail'];
    $thumbnail_path = $current_thumbnail;

    // নতুন থাম্বনেইল আপলোড হয়েছে কিনা দেখুন
    if (isset($_FILES['thumbnail_file']) && $_FILES['thumbnail_file']['error'] == 0) {
        $upload_dir = '../uploads/stream_thumbnails/';
        $thumb_file_name = time() . '_' . basename($_FILES["thumbnail_file"]["name"]);
        $thumb_target_file = $upload_dir . $thumb_file_name;
        
        if (move_uploaded_file($_FILES["thumbnail_file"]["tmp_name"], $thumb_target_file)) {
            // নতুন ফাইল আপলোড হলে পুরনোটি ডিলিট করুন
            if (!empty($current_thumbnail) && file_exists('../' . $current_thumbnail)) {
                unlink('../' . $current_thumbnail);
            }
            $thumbnail_path = "uploads/stream_thumbnails/" . $thumb_file_name;
        }
    }

    if (filter_var($stream_url, FILTER_VALIDATE_URL)) {
        $sql = "UPDATE live_streams SET title = ?, stream_url = ?, thumbnail_path = ? WHERE id = ?";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("sssi", $title, $stream_url, $thumbnail_path, $id);
        
        if ($stmt->execute()) {
            header("Location: manage_streams.php");
            exit();
        } else {
            $message = "<div class='alert alert-danger'>আপডেট করতে সমস্যা হয়েছে: " . $conn->error . "</div>";
        }
    } else {
        $message = "<div class='alert alert-warning'>অনুগ্রহ করে একটি বৈধ URL দিন।</div>";
    }
}

// ডেটাবেস থেকে বর্তমান তথ্য আনুন
$sql_select = "SELECT title, stream_url, thumbnail_path FROM live_streams WHERE id = ?";
$stmt_select = $conn->prepare($sql_select);
$stmt_select->bind_param("i", $id);
$stmt_select->execute();
$result = $stmt_select->get_result();
if ($result->num_rows > 0) {
    $stream = $result->fetch_assoc();
} else {
    header("Location: manage_streams.php");
    exit();
}
?>

<?php include '../includes/header.php'; ?>
<?php include '../includes/sidebar.php'; ?>

<h1 class="mt-4">লাইভ স্ট্রিম এডিট করুন</h1>

<?php echo $message; ?>

<div class="card my-4">
    <div class="card-header">স্ট্রিমের তথ্য পরিবর্তন করুন</div>
    <div class="card-body">
        <form action="edit_stream.php" method="post" enctype="multipart/form-data">
            <input type="hidden" name="id" value="<?php echo $id; ?>">
            <input type="hidden" name="current_thumbnail" value="<?php echo htmlspecialchars($stream['thumbnail_path']); ?>">
            
            <div class="form-group">
                <label for="stream_title">স্ট্রিমের টাইটেল</label>
                <input type="text" name="stream_title" id="stream_title" class="form-control" value="<?php echo htmlspecialchars($stream['title']); ?>" required>
            </div>
            <div class="form-group">
                <label for="stream_url">স্ট্রিম URL</label>
                <input type="url" name="stream_url" id="stream_url" class="form-control" value="<?php echo htmlspecialchars($stream['stream_url']); ?>" required>
            </div>

            <div class="form-group">
                <label>বর্তমান থাম্বনেইল</label><br>
                <?php if (!empty($stream['thumbnail_path']) && file_exists('../' . $stream['thumbnail_path'])): ?>
                    <img src="../<?php echo htmlspecialchars($stream['thumbnail_path']); ?>" alt="Thumbnail" style="width: 200px; height: auto; margin-bottom: 10px;">
                <?php else: ?>
                    <p>কোনো থাম্বনেইল যোগ করা হয়নি।</p>
                <?php endif; ?>
            </div>
            
            <div class="form-group">
                <label for="thumbnail_file">থাম্বনেইল পরিবর্তন করুন (ঐচ্ছিক)</label>
                <input type="file" name="thumbnail_file" id="thumbnail_file" class="form-control-file" accept="image/*">
            </div>

            <button type="submit" class="btn btn-primary">আপডেট করুন</button>
            <a href="manage_streams.php" class="btn btn-secondary">ফিরে যান</a>
        </form>
    </div>
</div>

<?php include '../includes/footer.php'; ?>
<?php $conn->close(); ?>